<?php 

namespace App\Models;
use CodeIgniter\Model;

class UsersModel extends Model{
    
    protected $table = 'tbl_users';
    protected $primaryKey = 'id';
    protected $allowedFields = [];
    
    public function __construct(){
        parent::__construct();
        $this->allowedFields = $this->db->getFieldNames($this->table);
    }
    
    public function getMonthlyRegistrations($mon = null, $year = null){
        if (!$year) {
            $year = date('Y'); // Default to current year
        }
        
        if (!$mon) {
            $mon = date('n'); // Default to current month if not provided
        }
        
        $db = \Config\Database::connect();
        $sql_user = "SELECT `id` FROM tbl_users WHERE `registered_on` <> 0 AND DATE_FORMAT(FROM_UNIXTIME(`registered_on`), '%c') = ? AND DATE_FORMAT(FROM_UNIXTIME(`registered_on`), '%Y') = ?";
        $query = $db->query($sql_user, [$mon, $year]);
        return $query->getNumRows();
    }
    
    public static function getUserdata($user_id = '0') {
        if ($user_id == '0') {
            return null; // Return null if no user ID is provided
        }
        // Get instance of the model
        $model = new self();
        return $model->where('id', $user_id)->first();
    }
}